<?php namespace Visiosoft\CouponModule\Coupon\Form\Command;

use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CouponModule\Coupon\Form\CouponFormBuilder;

class AddEntryField
{
    protected $builder;

    public function __construct(CouponFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    public function handle(StreamRepositoryInterface $streamRepository)
    {
        $this->builder->setType(request('type'));

        if (!$this->builder->getType()) {
            throw new \Exception(trans('visiosoft.module.coupon::message.the_type_parameter_is_required'));
        }

        $stream = $streamRepository->find($this->builder->getType());

        $this->builder->addField('coupon_type_entry', [
            'label' => $stream->name,
            'type' => 'anomaly.field_type.select',
            'required' => true,
        ]);
    }
}
