<?php namespace Visiosoft\CouponModule\Code\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;

class CodesExport implements FromCollection, WithHeadings
{
    protected $couponID;

    public function __construct($couponID)
    {
        $this->couponID = $couponID;
    }

    public function collection()
    {
        $codeRepository = app(CodeRepositoryInterface::class);
        return $codeRepository->newQuery()
            ->select('coupon_id', 'code')
            ->where('coupon_id', $this->couponID)
            ->get();
    }

    public function headings(): array
    {
        return [
            'Coupon ID',
            'Code',
        ];
    }
}
