<?php namespace Visiosoft\CouponModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CouponModule\Coupon\Form\CouponFormBuilder;
use Visiosoft\CouponModule\Coupon\Table\CouponTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CouponController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CouponTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CouponTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CouponFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CouponFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CouponFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CouponFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function getStreamEntryAjax(StreamRepositoryInterface $streamRepository, $stream_id)
    {
        $response = [
            'status' => false,
            'entries' => []
        ];

        if ($stream = $streamRepository->find($stream_id)) {

            $entry_model = $stream->getEntryModel();

            $title_columns = [
                'users' => 'email',
                'store' => 'name',
            ];


            $title_column = $entry_model->getTitleName();

            $namespace = $stream->getNamespace();

            if (array_key_exists($namespace, $title_columns)) {
                $title_column = $title_columns[$namespace];
            }

            $all_entry = $entry_model->get();

            if ($namespace == "cats") {
                $all_entry = $entry_model->get()->mainCategories();
            }

            $entries = [];

            foreach ($all_entry->pluck($title_column, 'id')->all() as $entry_id => $entry_title) {
                $entry = [
                    'value' => strval($entry_id),
                    'label' => $entry_title
                ];

                $entries[] = $entry;
            }


            $response['status'] = true;
            $response['entries'] = $entries;
        }
        return response()->json($response);

    }
}
