<?php namespace Visiosoft\CouponModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CouponModule\Coupon\CartsForm\CartsFormBuilder;
use Visiosoft\CouponModule\Coupon\Listeners\UsedCouponForCreatedOrder;
use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;
use Visiosoft\CouponModule\UsedCoupon\UsedCouponRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponUsedCouponsEntryModel;
use Visiosoft\CouponModule\UsedCoupon\UsedCouponModel;
use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\Coupon\CouponRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponCouponEntryModel;
use Visiosoft\CouponModule\Coupon\CouponModel;
use Illuminate\Routing\Router;
use Visiosoft\OrdersModule\Events\OrderCreated;

class CouponModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/coupon' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@index',
        'admin/coupon/create' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@create',
        'admin/coupon/edit/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@edit',
        'admin/coupon/used_coupons' => 'Visiosoft\CouponModule\Http\Controller\Admin\UsedCouponsController@index',
        'admin/coupon/get-entries/{stream_id}' => [
            'as' => 'visiosoft.module.coupon::coupon.get_stream_entry_ajax',
            'uses' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@getStreamEntryAjax',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\CouponModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\CouponModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        OrderCreated::class => [
            UsedCouponForCreatedOrder::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\CouponModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CouponUsedCouponsEntryModel::class => UsedCouponModel::class,
        CouponCouponEntryModel::class => CouponModel::class,
        'coupon_form' => CartsFormBuilder::class
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UsedCouponRepositoryInterface::class => UsedCouponRepository::class,
        CouponRepositoryInterface::class => CouponRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
