<?php namespace Visiosoft\CouponModule\Coupon\Traits;


use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;

trait executeDiscount
{
    use DispatchesJobs;

    public function execute($coupon)
    {

        $usedCouponRepository = app(UsedCouponRepositoryInterface::class);

        $message = app(MessageBag::class);

        $entries = $coupon->getCouponTypeEntries();

        $type = $coupon->getType();

        $entry_model = $type->getEntryModel();

        $cart = $this->dispatch(new GetCart());

        $status = true;


        //Check Expiry
        if ($coupon->coupon_expiry_at and $coupon->coupon_expiry_at < now()) {
            $status = false;
        }

        //Check Min Price
        if ($min = $coupon->min_cart_price and $min > $cart->total) {
            $status = false;
        }

        //Check Auth Used
        if ($coupon->used_only_once
            and $usedCoupon = $usedCouponRepository->findByCouponId($coupon->getId())
            and $usedCoupon->user_id == Auth::id()) {
            $status = false;
        }

        $discount_amount = 0;

        if ($status) {
            if ($entries and count($entries)) {
                if ($type->slug == 'users' and $type->namespace == "users") {
                    if (in_array(Auth::id(), $entries)) {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    }
                } else if ($type->slug == 'advs' and $type->namespace == "advs") {

                    if ($coupon->value_discount_type == "apply_to_cart") {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    } else {
                        foreach ($cart->items as $item) {
                            $id = $item->entry_id;
                            if (in_array($id, $entries)) {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                } else if ($type->slug == 'category' and $type->namespace == "cats") {
                    foreach ($cart->items as $item) {
                        $item_entry = $item->entry;
                        if (in_array($item_entry->cat1, $entries)) {

                            if ($coupon->value_discount_type == "apply_to_cart") {
                                $discount_amount = $this->calculateCart($cart->total, $coupon);
                                break;
                            } else {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                } else if ($type->slug == 'store' and $type->namespace == "store") {

                    //brings the owners of the items in the carts
                    $cart_item_owners = [];
                    foreach ($cart->items as $item) {
                        if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                            $cart_item_owners[] = $item->entry->created_by_id;
                        }
                    }
                    $cart_item_owners = array_unique($cart_item_owners);

                    //bring in store users
                    $store_users = [];
                    foreach ($entries as $entry) {
                        if ($store = $entry_model->find($entry)) {
                            $users = $store->getStoreUsers()->pluck('id')->all();
                            $store_users = array_merge($store_users, $users);
                        }
                    }
                    $store_users = array_unique($store_users);

                    if ($coupon->price_discount_type == "apply_to_cart") {
                        if (count(array_intersect($cart_item_owners, $store_users))) {
                            $discount_amount = $this->calculateCart($cart->total, $coupon);
                        }
                    } else {
                        foreach ($cart->items as $item) {
                            $created_id = $item->entry->created_by_id;
                            if (in_array($created_id, $store_users)) {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                }
            } else {
                $discount_amount = $this->calculateCart($cart->total, $coupon);
            }
        }

        return $discount_amount;
    }

    public function calculateCart($price, $coupon)
    {
        if ($coupon->discount_type == 'percentage') {
            $discount = ($price * $coupon->discount_value) / 100;
        } else {
            $discount = $coupon->discount_value;
        }

        return $discount;
    }
}
