<?php namespace Visiosoft\CouponModule\Coupon;

use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CouponRepository extends EntryRepository implements CouponRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CouponModel
     */
    protected $model;

    /**
     * Create a new CouponRepository instance.
     *
     * @param CouponModel $model
     */
    public function __construct(CouponModel $model)
    {
        $this->model = $model;
    }

    public function findByCode($code)
    {
        return $this->findBy('coupon_code', $code);
    }

}
