<?php namespace Visiosoft\CouponModule\Group\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class GroupFormFields
{
    public function handle(GroupFormBuilder $builder)
    {
        $builder->setFields([
            'name',
            'type' => [
                'config' => [
                    "mode" => "search",
                    "handler" => function (RelationshipFieldType $fieldType, StreamRepositoryInterface $streams) {
                        $streams = $streams->newQuery()->get();

                        $entry_types = array();
                        foreach ($streams as $stream) {
                            $entry_types[$stream->getId()] = trans($stream->name)."(".ucfirst($stream->namespace).")";
                        }

                        $fieldType->setOptions($entry_types);
                    }
                ],
            ],
        ]);
    }
}
