<?php namespace Visiosoft\CouponModule\Group\EntryForm;

use Anomaly\MultipleFieldType\MultipleFieldType;

class GroupEntryFormFields
{
    public function handle(GroupEntryFormBuilder $builder)
    {

        $stream = $builder->getFormEntry();

        $type = $stream->getType();

        $entry_model = $type->getEntryModel();

        $builder->setFields([
            'entry' => [
                'type' => 'anomaly.field_type.multiple',
                "value" => function () use ($stream) {
                    return $stream->getEntries();
                },
                'config' => [
                    "handler" => function (MultipleFieldType $fieldType) use ($entry_model) {
                        $fieldType->setOptions($entry_model->get()->pluck($entry_model->getTitleName(), 'id')->all());
                    },

                ],
            ],
        ]);
    }
}
