<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCouponCreateCouponFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\Streams\Platform\Stream\StreamModel::class,
            ],
        ],
        'group' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CouponModule\Group\GroupModel::class,
            ],
        ],
        'entry_json' => 'visiosoft.field_type.json',
        'expiry_at' => 'anomaly.field_type.datetime',
        'min_price' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 0,
            ],
        ],
        'is_percent' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'code' => 'anomaly.field_type.text',
        'value' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'decimal' => 2,
                'separator' => '.',
                'point' => ','
            ],
        ],
    ];

}
