<?php namespace Visiosoft\CorporationTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;

class PostFieldsSeeder extends Seeder
{

    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;

    public function __construct(
        FieldRepositoryInterface      $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface     $streamRepository
    )
    {
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    public function run()
    {
        if ($stream = $this->streamRepository->findBySlugAndNamespace('default_posts', 'posts')) {
            $postFields = [
                [
                    'name' => trans('visiosoft.theme.corporation::field.breadcrumb_image'),
                    'namespace' => 'posts',
                    'slug' => 'breadcrumb',
                    'type' => 'anomaly.field_type.file',
                    'config' => [
                        'folders' => ['images'],
                    ],
                ]
            ];

            foreach ($postFields as $postField) {
                if (!$field = $this->fieldRepository->findBySlugAndNamespace($postField['slug'], $postField['namespace'])) {
                    $field = $this->fieldRepository->create([
                        'name' => $postField['name'],
                        'namespace' => $postField['namespace'],
                        'slug' => $postField['slug'],
                        'type' => $postField['type'],
                        'config' => $postField['config'],
                        'locked' => 0
                    ]);
                }

                if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
                    $this->assignmentRepository->create([
                        'stream_id' => $stream->getId(),
                        'field_id' => $field->id,
                        'label' => $postField['name'],
                    ]);
                }
            }
        }
    }
}
