<?php namespace Visiosoft\CorporationTheme\Seed;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Blocks\BlocksResponsiveTwoColumnsBlocksEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;

class MiddleSectionSeed extends Seeder
{

	private $areaRepository;
	private $blocksTypeRepository;
	private $fieldRepository;
	private $assignmentRepository;
	private $streamRepository;
	private $blockRepository;

	public function __construct(
		AreaRepositoryInterface $areaRepository,
		TypeRepositoryInterface $blocksTypeRepository,
		FieldRepositoryInterface $fieldRepository,
		AssignmentRepositoryInterface $assignmentRepository,
		StreamRepositoryInterface $streamRepository,
		BlockRepositoryInterface $blockRepository
	)
	{
		$this->areaRepository = $areaRepository;
		$this->blocksTypeRepository = $blocksTypeRepository;
		$this->fieldRepository = $fieldRepository;
		$this->assignmentRepository = $assignmentRepository;
		$this->streamRepository = $streamRepository;
		$this->blockRepository = $blockRepository;
	}

	/**
	 * Run the database seeds.
	 */
	public function run()
	{
		// Create block area
		if (!$middleSectionArea = $this->areaRepository->findBySlug('middle-section')) {
			$middleSectionArea = $this->areaRepository->create([
				'name' => trans('visiosoft.theme.corporation::field.middle_section'),
				'slug' => 'middle-section',
			]);
		}

		// Create block type
		if (!$blockType = $this->blocksTypeRepository->findBySlug('responsive_two_columns')) {
			$blockType = $this->blocksTypeRepository->create([
				'name' => trans('visiosoft.theme.corporation::field.responsive_two_columns'),
				'slug' => 'responsive_two_columns',
				'category' => 'content',
				'content_layout' => '<div class="container py-4 world-partner">
                                    <h2 class="mb-3">{{ block.title }}</h2>
                                    <div class="row">
                                        <div class="col-12 col-md-6 mx-auto">
                                            <p class="lead">{{ block.first_column }}</p>
                                        </div>
                                        <div class="col-12 col-md-6 mx-auto">
                                            <p class="lead">{{ block.second_column }}</p>
                                        </div>
                                    </div>
                                </div>',
				'wrapper_layout' => '{% extends "anomaly.module.blocks::types.wrapper" %}'
			]);
		}

		// Create block fields
		$blocksFields = [
			'first_column' => [
				'name' => trans('visiosoft.theme.corporation::field.first_column'),
				'namespace' => 'blocks',
				'slug' => 'first_column',
				'type' => 'anomaly.field_type.textarea'
			],
			'second_column' => [
				'name' => trans('visiosoft.theme.corporation::field.second_column'),
				'namespace' => 'blocks',
				'slug' => 'second_column',
				'type' => 'anomaly.field_type.textarea'
			]
		];

		$typeStream = $this->streamRepository->findBySlugAndNamespace('responsive_two_columns_blocks', 'blocks');

		foreach ($blocksFields as $blocksField) {
			if (!$field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], $blocksField['namespace'])) {
				$field = $this->fieldRepository->create([
					'name' => $blocksField['name'],
					'namespace' => $blocksField['namespace'],
					'slug' => $blocksField['slug'],
					'type' => $blocksField['type'],
					'locked' => 0
				]);
			}
			if (!$this->assignmentRepository->findByStreamAndField($typeStream, $field)) {
				$this->assignmentRepository->create([
					'stream' => $typeStream,
					'field' => $field,
					'translatable' => true,
				]);
			}

		}

		// Add default instructions

		$blockInfo = app(BlocksResponsiveTwoColumnsBlocksEntryModel::class)
			->newQuery()->create([
				'first_column' => trans('visiosoft.theme.corporation::field.my_partner.part_1'),
				'second_column' => trans('visiosoft.theme.corporation::field.my_partner.part_2')
			]);


		$blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();
		$block = $this->blockRepository->create([
			'field_id' => $blockFieldId,
			'extension' => 'anomaly.extension.responsive_two_columns_block',
			'display_title' => false,
			'entry' => $blockInfo,
			'area' => $middleSectionArea
		]);
	}
}