<?php namespace Visiosoft\Emlak24Theme\Seed;

use Illuminate\Database\Seeder;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class ShowcaseCategoriesSeed extends Seeder
{

    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * Run the database seeds.
     */
    public function run()
    {
        $categories = [
            [
                'name' => trans('visiosoft.theme.emlak24::field.new_projects'),
                'slug' => 'new_projects',
            ],
            [
                'name' => trans('visiosoft.theme.emlak24::field.lands'),
                'slug' => 'lands',
            ],
            [
                'name' => trans('visiosoft.theme.emlak24::field.deals_and_discounted_apartments'),
                'slug' => 'deals_and_discounted_apartments',
            ],
        ];

        foreach ($categories as $category) {
            $this->categoryRepository->newQuery()->firstOrCreate(
                ['slug' => $category['slug']],
                ['name' => $category['name']]
            );
        }
    }
}