<?php namespace Visiosoft\CorporationTheme;

use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterAnimatedTextRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFeaturesRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterGalleryRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterIntroSliderRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterServicesRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Visiosoft\CorporationTheme\Seed\MiddleSectionSeed;
use Visiosoft\CorporationTheme\Seed\ShowcaseCategoriesSeed;
use Visiosoft\CorporationTheme\Seed\PostFieldsSeeder;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterDividedAreaRepeaterEntryModel;



class CorporationThemeSeeder extends Seeder
{
	protected $pages,
		$types,
		$fields,
		$assignments,
		$streamRepository,
        $settingRepository;
    /**
     * @var SettingRepositoryInterface
     */

    public function __construct(
		PageRepositoryInterface $pages,
		TypeRepositoryInterface $types,
		FieldRepositoryInterface $fields,
		AssignmentRepositoryInterface $assignments,
		StreamRepositoryInterface $streamRepository,
        SettingRepositoryInterface $settingRepository
	)
	{
		$this->pages = $pages;
		$this->types = $types;
		$this->fields = $fields;
		$this->assignments = $assignments;
		$this->streamRepository = $streamRepository;
        $this->settingRepository = $settingRepository;
    }

	/**
     * Run the seeder.
     */
    public function run()
    {
        // Middle Section Block Seeder
        $this->call(MiddleSectionSeed::class);

        // Showcase Categories Seeder
        $this->call(ShowcaseCategoriesSeed::class);

        //Post Fields Seeder
        $this->call(PostFieldsSeeder::class);

        // Setting intro page in settings.
        $this->settingRepository->set('visiosoft.theme.corporation::change_intro_page', 18);
        $this->settingRepository->set('visiosoft.theme.corporation::intro_page', true);

		$repeaters = [
			'intro_slider_repeater' => [
				'content' => [
					'name' => 'Intro Slider Repeater',
					'namespace' => 'repeater',
					'slug' => 'intro_slider_repeater',
					'prefix' => 'repeater_',
                    'translatable' => true
				],
				'fields' => [
					'slider_img', 'title', 'description',
				]
			],
            'animated_text_repeater'  => [
                'content' => [
                    'name' => 'Animated Text Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'animated_text_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true
                ],
                'fields' => [
                    'animated_words', 'editor', 'slider_img' ,
                ]
            ],
            'divided_area_repeater' => [
                'content' => [
                    'name' => 'Divided Area Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'divided_area_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true
                ],
                'fields' => [
                    'area_image_one','category_title1','category_link1', 'area_image_two', 'category_link2', 'category_title2','button_text',
                ]
            ],
			'features_repeater' => [
				'content' => [
					'name' => 'Features Repeater',
					'namespace' => 'repeater',
					'slug' => 'features_repeater',
					'prefix' => 'repeater_',
                    'translatable' => true
                ],
				'fields' => [
					'file', 'title', 'description',
				]
			],
			'services_repeater' => [
				'content' => [
					'name' => 'Services Repeater',
					'namespace' => 'repeater',
					'slug' => 'services_repeater',
					'prefix' => 'repeater_',
                    'translatable' => true
                ],
				'fields' => [
					'file', 'title', 'description',
				]
			],
            'gallery_repeater' => [
                'content' => [
                    'name' => 'Gallery Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'gallery_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true
                ],
                'fields' => [
                    'file', 'title', 'description'
                ]
            ],
		];

		foreach ($repeaters as $slug => $item) {
			if (!$repeater = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')){
				$repeater = $this->streamRepository->create($item['content']);
			}

			$fields_repeater = [
				'file' => [
					'field_attributes' => [
						'name' => 'File',
						'namespace' => 'repeater',
						'slug' => 'file',
						'type' => 'anomaly.field_type.file',
						'locked' => 0,
						"config" => [
							"folders" => ['images'],
							"mode" => 'upload',
						],
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => false,
					]
				],
				'slider_img' => [
					'field_attributes' => [
						'name' => 'Slider Img',
						'instructions' => '1500x630',
						'namespace' => 'repeater',
						'slug' => 'slider_img',
						'type' => 'anomaly.field_type.file',
						'locked' => 0,
						"config" => [
							"folders" => ['images'],
							"mode" => 'upload',
						],
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => false,
					]
				],
				'title' => [
					'field_attributes' => [
						'name' => 'Title',
						'namespace' => 'repeater',
						'slug' => 'title',
						'type' => 'anomaly.field_type.text',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => true,
						'translatable' => true,
					]
				],
				'description' => [
					'field_attributes' => [
						'name' => 'Description',
						'namespace' => 'repeater',
						'slug' => 'description',
						'type' => 'anomaly.field_type.textarea',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => true,
						'translatable' => true,
					]
				],
				'editor' => [
					'field_attributes' => [
						'name' => 'Editor',
						'namespace' => 'repeater',
						'slug' => 'editor',
						'type' => 'anomaly.field_type.editor',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => true,
					]
				],
                'animated_words' => [
                    'field_attributes' => [
                        'name' => 'Animated Words',
                        'namespace' => 'repeater',
                        'slug' => 'animated_words',
                        'type' => 'anomaly.field_type.tags',
                        "config" => [
                            "default_value" => ['Animated Text 1', 'Animated Text 2', 'Animated Text 3', 'Animated Text 4'],
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                // Divider Area Fields
                'area_image_one' => [
                    'field_attributes' => [
                        'name' => 'Area Image One',
                        'namespace' => 'repeater',
                        'slug' => 'area_image_one',
                        'type' => 'anomaly.field_type.file',
                        'locked' => 0,
                        "config" => [
                            "folders" => ['images'],
                            "mode" => 'upload',
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false
                    ]
                ],



                'area_image_two' => [
                    'field_attributes' => [
                        'name' => 'Area Image two',
                        'namespace' => 'repeater',
                        'slug' => 'area_image_two',
                        'type' => 'anomaly.field_type.file',
                        'locked' => 0,
                        "config" => [
                            "folders" => ['images'],
                            "mode" => 'upload',
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false
                    ]
                ],
                'category_title1' => [
                    'field_attributes' => [
                        'name' => 'Category 1 Title',
                        'namespace' => 'repeater',
                        'slug' => 'category_title1',
                        'type' => 'anomaly.field_type.text',
                        "config" => [
                            "default_value" => "Title One",
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'category_title2' => [
                    'field_attributes' => [
                        'name' => 'Category 2 Title',
                        'namespace' => 'repeater',
                        'slug' => 'category_title2',
                        'type' => 'anomaly.field_type.text',
                        "config" => [
                            "default_value" => "Title Two",
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'category_link1' => [
                    'field_attributes' => [
                        'name' => 'Category 1 URL',
                        'namespace' => 'repeater',
                        'slug' => 'category_link1',
                        'type' => 'anomaly.field_type.text',
                        "config" => [
                            "default_value" => "/c",
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'category_link2' => [
                    'field_attributes' => [
                        'name' => 'Category 2 URL',
                        'namespace' => 'repeater',
                        'slug' => 'category_link2',
                        'type' => 'anomaly.field_type.text',
                        "config" => [
                            "default_value" => "/c",
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'button_text' => [
                    'field_attributes' => [
                        'name' => 'Button Text',
                        'namespace' => 'repeater',
                        'slug' => 'button_text',
                        'type' => 'anomaly.field_type.text',
                        "config" => [
                            "default_value" => "See More",
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ]
			];

			foreach ($fields_repeater as $field_slug => $field_repeater){
				if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'repeater')){
					$field = $this->fields->create($field_repeater['field_attributes']);
				}

				if (in_array($field->getSlug(), $item['fields'])){
					if (!$this->assignments->findByStreamAndField($repeater, $field)) {
						// File Field Assignment
						$this->assignments->create(
							array_merge([
								'stream' => $repeater,
								'field' => $field,
							], $field_repeater['assignment_attributes'])
						);
					}
				}
			}


        }

		$fields = [
			'intro_slider_repeater_fields' => [
				'name' => 'Intro Page Slider Repeater Fields',
				'namespace' => 'pages',
				'slug' => 'intro_slider_repeater_fields',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterIntroSliderRepeaterEntryModel::class,
                    'translatable' => true
				]
			],
            'animated_text_repeater_fields' => [
                'name' => 'Animated Text Repeater Fields',
                'namespace' => 'pages',
                'slug' => 'animated_text_repeater_fields',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterAnimatedTextRepeaterEntryModel::class,
                    'translatable' => true
                ]
            ],
            'divided_area_repeater_fields' => [
                'name' => 'Divided Area Repeater Fields',
                'namespace' => 'pages',
                'slug' => 'divided_area_repeater_fields',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterDividedAreaRepeaterEntryModel::class,
                    'translatable' => true
                ]
            ],
			'slider_button_text' => [
				'name' => 'Slider Button Text',
				'namespace' => 'pages',
				'slug' => 'slider_button_text',
				'type' => 'anomaly.field_type.text',
				'locked' => 0,
                'config' => [
                    'default_value' => 'See More',
                    'translatable' => true
                ]
            ],
			'features_repeater' => [
				'name' => 'Features Repeater',
				'namespace' => 'pages',
				'slug' => 'features_repeater',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterFeaturesRepeaterEntryModel::class,
                    'translatable' => true
                ]
			],
			'first_info_img' => [
				'name' => 'First Info Area Img',
				'namespace' => 'pages',
				'slug' => 'first_info_img',
				'type' => 'anomaly.field_type.file',
				'locked' => 0
			],
            'features_parallax' => [
                'name' => 'Features Parallax Img',
                'namespace' => 'pages',
                'slug' => 'features_parallax',
                'type' => 'anomaly.field_type.file',
                'locked' => 0
            ],
            'gallery_parallax' => [
                'name' => 'Gallery Parallax Img',
                'namespace' => 'pages',
                'slug' => 'gallery_parallax',
                'type' => 'anomaly.field_type.file',
                'locked' => 0
            ],
            'youtube_url' => [
                'name' => 'Youtube Video Url',
                'namespace' => 'pages',
                'slug' => 'youtube_url',
                'type' => 'anomaly.field_type.url',
                'locked' => 0
            ],
			'first_info_content' => [
				'name' => 'First Info Area Content',
				'namespace' => 'pages',
				'slug' => 'first_info_content',
				'type' => 'anomaly.field_type.editor',
				'locked' => 0,
                'config' => [
                    'default_value' => '<div class="padding-10-perc grey-bg background-80 background-no-repeat background-center">
                        <div class="section-heading text-left">
                            <small class="grey-color font-size-20 font-weight-normal">İşletmelerde, huzurlu ve kurumsal bir yapı geliştirmeyi görev sayan,</small>
                            <h4 class="semi-bold font-size-35">SİTENİZ’LE YENİ UFUKLARA</h4>
                        </div>
                        <div class="text-content mt-20">
                            <p>Her işletme süreçlerini yönetirken, kontrol bağlamında kritik bir eşik sınıra gelir.
                    İşletme, aldığı doğru çözüm hizmetleriyle bu eşik sınır, başarıyla atlatılır. SİTENİZ bu gelişim yolculuğunda, saha ve akademik yetkinliğe sahip ekibiyle, size eşlik eder. Elde ettiğimiz sonuçlar sayesinde;</p>
                        </div>
                        <ul class="primary-list mt-20">
                            <li><i class="fas fa-check"></i>HATALARIN ÇABUK TESBİTİ İLE İŞLETME ZAMAN KAYBI YAŞAMAZ</li>
                            <li><i class="fas fa-check"></i>KAYNAKLARIN DOĞRU YÖNETİMİ İLE İŞLETMEDE KARLILIK ARTAR</li>
                            <li><i class="fas fa-check"></i>KURUMSAL YAPININ OTURMASIYLA, İŞLETME DAHA VERİMLİ HALE GELİR</li>
                        </ul>
                        <div class="mt-40">
                            <a href="{{ page(setting_value("visiosoft.theme.corporation::info_pages")).getPath }}" class="button-primary button-sm">Daha Fazla Gör</a>
                        </div>
                    </div>
                    ',
                    'translatable' => true
                ]
            ],
			'second_info_img' => [
				'name' => 'Second Info Area Img',
				'namespace' => 'pages',
				'slug' => 'second_info_img',
				'type' => 'anomaly.field_type.file',
				'locked' => 0
			],
			'second_info_content' => [
				'name' => 'Second Info Area Content',
				'namespace' => 'pages',
				'slug' => 'second_info_content',
				'type' => 'anomaly.field_type.editor',
				'locked' => 0,
                'config' => [
                    'default_value' => '<div class="padding-10-perc grey-bg background-80 background-no-repeat background-center">
                        <div class="section-heading text-left">
                            <small class="grey-color font-size-20 font-weight-normal">Hizmetlerimizle, işletmedeki stratejik kazanımlarımız,</small>
                            <h4 class="semi-bold font-size-35">Süreç, Personel ve Kar bazlı başarılar olmaktadır.</h4>
                        </div>
                        <div class="text-content mt-20">
                            <p>SİTENİZ, PROJELERİ İLE BULUŞAN SİZ SEVGİLİ DOSTLARDAN ALDIĞI SAYISAL GERİ DÖNÜŞLERE GÖRE, MUTLULUK TABLOSUNU SİZİNLE PAYLAŞMAKTAN GURUR DUYAR. </p>
                        </div>
                        <div class="wow fadeInUpSm" data-wow-delay="0.5s">
                            <div class="progress-bar-title clearfix">
                                <h5>SÜREÇ BAZLI VERİM</h5>
                                <h6>{{ setting_value("visiosoft.theme.corporation::analyst_bar") }}%</h6>
                            </div>
                            <div class="progress progress-bar-sm">
                                <div class="progress-bar progress-bar-gradient slideInLeft wow animated"
                                     style="width:{{ setting_value("visiosoft.theme.corporation::analyst_bar") }}%"></div>
                            </div>
                            <div class="progress-bar-title clearfix">
                                <h5>PERSONEL BAZLI VERİM</h5>
                                <h6>{{ setting_value("visiosoft.theme.corporation::marketing_bar") }}%</h6>
                            </div>
                            <div class="progress progress-bar-sm">
                                <div class="progress-bar progress-bar-gradient slideInLeft wow animated"
                                     style="width:{{ setting_value("visiosoft.theme.corporation::marketing_bar") }}%"></div>
                            </div>
                            <div class="progress-bar-title clearfix">
                                <h5>KARLILIK</h5>
                                <h6>{{ setting_value("visiosoft.theme.corporation::social_media_bar") }}%</h6>
                            </div>
                            <div class="progress progress-bar-sm">
                                <div class="progress-bar progress-bar-gradient slideInLeft wow animated"
                                     style="width:{{ setting_value("visiosoft.theme.corporation::social_media_bar") }}%"></div>
                            </div>
                        </div>
                    </div>',
                    'translatable' => true
                ]
            ],
            'third_info_img' => [
                'name' => 'Third Info Area Img',
                'namespace' => 'pages',
                'slug' => 'third_info_img',
                'type' => 'anomaly.field_type.file',
                'locked' => 0
            ],
            'third_info_content' => [
                'name' => 'Third Info Area Content',
                'namespace' => 'pages',
                'slug' => 'third_info_content',
                'type' => 'anomaly.field_type.editor',
                'locked' => 0,
                'config' => [
                    'default_value' => '<div class="padding-10-perc grey-bg background-80 background-no-repeat background-center">
                        <div class="section-heading text-left">
                            <small class="grey-color font-size-20 font-weight-normal">Hizmetlerimizle, işletmedeki stratejik kazanımlarımız,</small>
                            <h4 class="semi-bold font-size-35">Süreç, Personel ve Kar bazlı başarılar olmaktadır.</h4>
                        </div>
                        <div class="text-content mt-20">
                            <p>SİTENİZ, PROJELERİ İLE BULUŞAN SİZ SEVGİLİ DOSTLARDAN ALDIĞI SAYISAL GERİ DÖNÜŞLERE GÖRE, MUTLULUK TABLOSUNU SİZİNLE PAYLAŞMAKTAN GURUR DUYAR. </p>
                        </div>
                        
                    </div>',
                    'translatable' => true
                ]
            ],
            'fourth_info_img' => [
                'name' => 'Fourth Info Area Img',
                'namespace' => 'pages',
                'slug' => 'fourth_info_img',
                'type' => 'anomaly.field_type.file',
                'locked' => 0
            ],
            'fourth_info_content' => [
                'name' => 'Fourth Info Area Content',
                'namespace' => 'pages',
                'slug' => 'fourth_info_content',
                'type' => 'anomaly.field_type.editor',
                'locked' => 0,
                'config' => [
                    'default_value' => '<div class="padding-10-perc grey-bg background-80 background-no-repeat background-center">
                        <div class="section-heading text-left">
                            <h4 class="semi-bold font-size-35">XXXXXXX XXXXXX Ne Yapıyor </h4>
                        </div>
                        <div class="text-content mt-20">
                            <p>Hedefleri olan gençlerin, her seferinde daha yeni işler yapmak isteyen atılımcıların, yeni mekanlar keşfetmek isteyen gezginlerin, dünyaya bambaşka açılardan bakabildiğini düşünen herkesin yapmayı düşlediği bir işi yapıyoruz. </p>
                        </div>
                        <div class="wow fadeInUpSm d-flex justify-content-between flex-column flex-sm-row mt-5" data-wow-delay="0.5s">
                            <div class="text-center">
								<img class="info-icon" src="files/images/consulting.png" >
								<p class="info-icon-text">
									TASARLAR
								</p>
							</div>
							<div class="text-center">
								<img class="info-icon" src="files/images/mentor.png" >
								<p class="info-icon-text">
									PLANLAR
								</p>
							</div>
							<div class="text-center">
								<img class="info-icon" src="files/images/kocluk.png" />
								<p class="info-icon-text">
									TESLİM EDER
								</p>
							</div>
                        </div>
                    </div>',
                    'translatable' => true
                ]
            ],
			'services_title' => [
				'name' => 'Services Section Title',
				'namespace' => 'pages',
				'slug' => 'services_title',
				'type' => 'anomaly.field_type.text',
				'locked' => 0,
                'config' => [
                    'default_value' => "Siteniz, işletmemizi bütün olgularıyla analiz ederek, size özel yol haritası kurguluyor.",
                    'translatable' => true
                ]
			],
			'services_description' => [
				'name' => 'Services Section Description',
				'namespace' => 'pages',
				'slug' => 'services_description',
				'type' => 'anomaly.field_type.textarea',
				'locked' => 0,
                'config' => [
                    'default_value' => "BİRLİKTE ÇIKACAĞIMIZ YOLCULUKLA, SİZE ÖZEL DENEYİMLERİ VE BAŞARILARI, İŞLETME MANİFESTOSUNA DÖNÜŞTÜRELİM.  BU KAZANIMLARLA YAZILI BİR KÜLTÜR OLUŞTURALIM. BU KÜLTÜRLE, İŞLETMEYİ VİZYONER ÇİZGİDE TUTUP, SÜREKLİ İNOVASYON ÜRETEN BİR GELENEĞE DÖNÜŞTÜRELİM.",
                    'translatable' => true
                ]
            ],
			'services_repeater' => [
				'name' => 'Services Repeater',
				'namespace' => 'pages',
				'slug' => 'services_repeater',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterServicesRepeaterEntryModel::class,
                    'translatable' => true
                ]
			],
            'gallery_repeater' => [
                'name' => 'Gallery Repeater',
                'namespace' => 'pages',
                'slug' => 'gallery_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterGalleryRepeaterEntryModel::class,
                    'translatable' => true
                ]
            ]
		];

		$types = [
			'intro_type' => [
				'content' => [
					'en' => [
						'name' => 'Intro Type',
					],
					'slug' => 'intro_type',
					'handler' => 'anomaly.extension.default_page_handler',
					'theme_layout' => 'theme::layouts/default.twig',
					'layout' => '<h1>{{ page.title }}</h1>',
				],
				'fields' => [
					'intro_slider_repeater_fields', 'animated_text_repeater_fields' ,  'slider_button_text', 'features_repeater',
					'first_info_img', 'first_info_content', 'second_info_img', 'second_info_content', 'third_info_img', 'third_info_content', 'fourth_info_img', 'fourth_info_content',
					'services_title', 'services_description', 'services_repeater', 'youtube_url', 'features_parallax', 'gallery_parallax', 'gallery_repeater'
				]
			],
			'intro_post' => [
				'content' => [
					'en' => [
						'name' => 'Intro Post',
					],
					'slug' => 'intro_post',
					'handler' => 'anomaly.extension.default_page_handler',
					'theme_layout' => 'theme::layouts/default.twig',
					'layout' => '{{ page.content|raw }}',
				],
				'fields' => [
					'content'
				]
			]
		];

	    foreach ($fields as $slug => $item) {
		    if (!$field = $this->fields->findBySlugAndNamespace($slug, 'pages')) {
			    $field = $this->fields->create($item);
		    }
	    }

	    foreach ($types as $type_slug => $type_content) {
		    if (!$type = $this->types->findBySlug($type_slug)) {
			    $type = $this->types->create($type_content['content']);

			    $stream = $type->getEntryStream();

			    foreach ($type_content['fields'] as $field) {
				    $this->assignments->create([
					    'stream' => $stream,
					    'field' => $this->fields->findBySlugAndNamespace($field, 'pages')
				    ]);
			    }
		    }
	    }

	    $pages = [
		    'intro-page' => [
			    'content' => [
				    'en' => [
					    'title' => 'Intro Page',
				    ],
				    'slug' => 'intro-page',
				    'enabled' => 'true',
				    'home' => false,
				    'theme_layout' => 'theme::layouts/default.twig',
			    ],
			    'entry_content' => [
				    'en' => [
					    'first_info_content' => 'qqq'
				    ]
			    ],
			    'type' => 'intro_type',
			    'children' => [],
		    ]
	    ];

	    foreach ($pages as $page) {
            if (!$this->pages->findBySlug($page['content']['slug'])) {
		    $type = $this->types->findBySlug($page['type']);
		    $selected_type = [];
		    foreach ($page['entry_content'] as $content) {
			    $selected_type = [
				    'type' => $type,
				    'entry' => $type->getEntryModel()->newQuery()->create($content)
			    ];
		    }
		    $new_page = array_merge($page['content'], $selected_type);
		    $this->pages->create($new_page);
            }
	    }

	    Model::unguard();
        DB::unprepared(file_get_contents(realpath(dirname(__DIR__)) . '/src/MailTemplates/templates.sql'));
        DB::unprepared(file_get_contents(realpath(dirname(__DIR__)) . '/src/Seed/data/corporation_seeder.sql'));
        Model::reguard();

        $zip = new \ZipArchive();
        $zip->open(__DIR__ . '/Seed/data/images.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/local/images/'));
        $zip->close();



        Artisan::call('files:sync');
        Artisan::call('assets:clear');

    }
}