<?php namespace Visiosoft\CorporationTheme;

use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFeaturesRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterIntroSliderRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterServicesRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Visiosoft\CorporationTheme\Seed\MiddleSectionSeed;
use Visiosoft\CorporationTheme\Seed\ShowcaseCategoriesSeed;

class CorporationThemeSeeder extends Seeder
{
	protected $pages,
		$types,
		$fields,
		$assignments,
		$streamRepository;

	public function __construct(
		PageRepositoryInterface $pages,
		TypeRepositoryInterface $types,
		FieldRepositoryInterface $fields,
		AssignmentRepositoryInterface $assignments,
		StreamRepositoryInterface $streamRepository
	)
	{
		$this->pages = $pages;
		$this->types = $types;
		$this->fields = $fields;
		$this->assignments = $assignments;
		$this->streamRepository = $streamRepository;
	}

	/**
     * Run the seeder.
     */
    public function run()
    {
        // Middle Section Block Seeder
        $this->call(MiddleSectionSeed::class);

        // Showcase Categories Seeder
        $this->call(ShowcaseCategoriesSeed::class);

		$repeaters = [
			'intro_slider_repeater' => [
				'content' => [
					'name' => 'Intro Slider Repeater',
					'namespace' => 'repeater',
					'slug' => 'intro_slider_repeater',
					'prefix' => 'repeater_',
				],
				'fields' => [
					'slider_img', 'title', 'description',
				]
			],
			'features_repeater' => [
				'content' => [
					'name' => 'Features Repeater',
					'namespace' => 'repeater',
					'slug' => 'features_repeater',
					'prefix' => 'repeater_',
				],
				'fields' => [
					'file', 'title', 'description',
				]
			],
			'services_repeater' => [
				'content' => [
					'name' => 'Services Repeater',
					'namespace' => 'repeater',
					'slug' => 'services_repeater',
					'prefix' => 'repeater_',
				],
				'fields' => [
					'file', 'title', 'description',
				]
			],
		];

		foreach ($repeaters as $slug => $item) {
			if (!$repeater = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')){
				$repeater = $this->streamRepository->create($item['content']);
			}

			$fields_repeater = [
				'file' => [
					'field_attributes' => [
						'name' => 'File',
						'namespace' => 'repeater',
						'slug' => 'file',
						'type' => 'anomaly.field_type.file',
						'locked' => 0,
						"config" => [
							"folders" => ['images'],
							"mode" => 'upload',
						],
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => false,
					]
				],
				'slider_img' => [
					'field_attributes' => [
						'name' => 'Slider Img',
						'instructions' => '1500x630',
						'namespace' => 'repeater',
						'slug' => 'slider_img',
						'type' => 'anomaly.field_type.file',
						'locked' => 0,
						"config" => [
							"folders" => ['images'],
							"mode" => 'upload',
						],
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => false,
					]
				],
				'title' => [
					'field_attributes' => [
						'name' => 'Title',
						'namespace' => 'repeater',
						'slug' => 'title',
						'type' => 'anomaly.field_type.text',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => true,
						'translatable' => true,
					]
				],
				'description' => [
					'field_attributes' => [
						'name' => 'Description',
						'namespace' => 'repeater',
						'slug' => 'description',
						'type' => 'anomaly.field_type.textarea',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => true,
						'translatable' => true,
					]
				],
				'editor' => [
					'field_attributes' => [
						'name' => 'Editor',
						'namespace' => 'repeater',
						'slug' => 'editor',
						'type' => 'anomaly.field_type.editor',
						'locked' => 0,
					],
					'assignment_attributes' => [
						'required' => false,
						'translatable' => false,
					]
				]
			];

			foreach ($fields_repeater as $field_slug => $field_repeater){
				if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'repeater')){
					$field = $this->fields->create($field_repeater['field_attributes']);
				}

				if (in_array($field->getSlug(), $item['fields'])){
					if (!$this->assignments->findByStreamAndField($repeater, $field)) {
						// File Field Assignment
						$this->assignments->create(
							array_merge([
								'stream' => $repeater,
								'field' => $field,
							], $field_repeater['assignment_attributes'])
						);
					}
				}
			}
		}

		$fields = [
			'intro_slider_repeater_fields' => [
				'name' => 'Intro Page Slider Repeater Fields',
				'namespace' => 'pages',
				'slug' => 'intro_slider_repeater_fields',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterIntroSliderRepeaterEntryModel::class
				]
			],
			'slider_button_text' => [
				'name' => 'Slider Button Text',
				'namespace' => 'pages',
				'slug' => 'slider_button_text',
				'type' => 'anomaly.field_type.text',
				'locked' => 0,
			],
			'features_repeater' => [
				'name' => 'Features Repeater',
				'namespace' => 'pages',
				'slug' => 'features_repeater',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterFeaturesRepeaterEntryModel::class
				]
			],
			'first_info_img' => [
				'name' => 'First Info Area Img',
				'namespace' => 'pages',
				'slug' => 'first_info_img',
				'type' => 'anomaly.field_type.file',
				'locked' => 0
			],
			'first_info_content' => [
				'name' => 'First Info Area Content',
				'namespace' => 'pages',
				'slug' => 'first_info_content',
				'type' => 'anomaly.field_type.editor',
				'locked' => 0
			],
			'second_info_img' => [
				'name' => 'Second Info Area Img',
				'namespace' => 'pages',
				'slug' => 'second_info_img',
				'type' => 'anomaly.field_type.file',
				'locked' => 0
			],
			'second_info_content' => [
				'name' => 'Second Info Area Content',
				'namespace' => 'pages',
				'slug' => 'second_info_content',
				'type' => 'anomaly.field_type.editor',
				'locked' => 0
			],
			'services_title' => [
				'name' => 'Services Section Title',
				'namespace' => 'pages',
				'slug' => 'services_title',
				'type' => 'anomaly.field_type.text',
				'locked' => 0
			],
			'services_description' => [
				'name' => 'Services Section Description',
				'namespace' => 'pages',
				'slug' => 'services_description',
				'type' => 'anomaly.field_type.textarea',
				'locked' => 0
			],
			'services_repeater' => [
				'name' => 'Services Repeater',
				'namespace' => 'pages',
				'slug' => 'services_repeater',
				'type' => 'anomaly.field_type.repeater',
				'locked' => 0,
				'config' => [
					'related' => RepeaterServicesRepeaterEntryModel::class
				]
			]
		];

		$types = [
			'intro_type' => [
				'content' => [
					'en' => [
						'name' => 'Intro Type',
					],
					'slug' => 'intro_type',
					'handler' => 'anomaly.extension.default_page_handler',
					'theme_layout' => 'theme::layouts/default.twig',
					'layout' => '<h1>{{ page.title }}</h1>',
				],
				'fields' => [
					'intro_slider_repeater_fields', 'slider_button_text', 'features_repeater',
					'first_info_img', 'first_info_content', 'second_info_img', 'second_info_content',
					'services_title', 'services_description', 'services_repeater'
				]
			],
			'intro_post' => [
				'content' => [
					'en' => [
						'name' => 'Intro Post',
					],
					'slug' => 'intro_post',
					'handler' => 'anomaly.extension.default_page_handler',
					'theme_layout' => 'theme::layouts/default.twig',
					'layout' => '{{ page.content|raw }}',
				],
				'fields' => [
					'content'
				]
			]
		];

	    foreach ($fields as $slug => $item) {
		    if (!$field = $this->fields->findBySlugAndNamespace($slug, 'pages')) {
			    $field = $this->fields->create($item);
		    }
	    }

	    foreach ($types as $type_slug => $type_content) {
		    if (!$type = $this->types->findBySlug($type_slug)) {
			    $type = $this->types->create($type_content['content']);

			    $stream = $type->getEntryStream();

			    foreach ($type_content['fields'] as $field) {
				    $this->assignments->create([
					    'stream' => $stream,
					    'field' => $this->fields->findBySlugAndNamespace($field, 'pages')
				    ]);
			    }
		    }
	    }

	    $pages = [
		    'intro-page' => [
			    'content' => [
				    'en' => [
					    'title' => 'Intro Page',
				    ],
				    'slug' => 'intro-page',
				    'enabled' => 'true',
				    'home' => false,
				    'theme_layout' => 'theme::layouts/default.twig',
			    ],
			    'entry_content' => [
				    'en' => [
					    'first_info_content' => 'qqq'
				    ]
			    ],
			    'type' => 'intro_type',
			    'children' => [],
		    ]
	    ];

	    foreach ($pages as $page) {
		    $type = $this->types->findBySlug($page['type']);
		    $selected_type = [];
		    foreach ($page['entry_content'] as $content) {
			    $selected_type = [
				    'type' => $type,
				    'entry' => $type->getEntryModel()->newQuery()->create($content)
			    ];
		    }
		    $new_page = array_merge($page['content'], $selected_type);
		    $this->pages->create($new_page);
	    }

	    Model::unguard();
        DB::unprepared(file_get_contents(realpath(dirname(__DIR__)) . '/src/MailTemplates/templates.sql'));
        Model::reguard();
    }
}