<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleComplaintsCreateUserComplaintsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'user_complaints',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => true,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'reporting_person' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ConnectModule\User\UserModel::class,
                'mode' => 'lookup'
            ]
        ],
        'reported_person' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ConnectModule\User\UserModel::class,
                'mode' => 'lookup'
            ]
        ]
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'reporting_person',
        'reported_person',
        'description',
        'type',
        'is_checked'
    ];

}
