<?php namespace Visiosoft\ComplaintsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\ComplaintsModule\AdvsComplaint\AdvsComplaintModel;
use Visiosoft\ComplaintsModule\AdvsComplaint\Form\AdvsComplaintFormBuilder;
use Visiosoft\ComplaintsModule\AdvsComplaint\Table\AdvsComplaintTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class AdvsComplaintsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param AdvsComplaintTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AdvsComplaintTableBuilder $table)
    {
        $status = [
            'value' => function (EntryModel $entry) {
                if ($entry->is_checked) {
                    return "<i class='fa fa-check'></i>";
                } else {
                    return "<a href='" . route('complaint_checked', [$entry->id]) . "' 
                                class='btn btn-success btn-xs'>".trans('visiosoft.module.complaints::field.checked.name')."</a>";
                }
            },
            'field' => 'status',
        ];
        $table->addColumn($status);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param AdvsComplaintFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(AdvsComplaintFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param AdvsComplaintFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(AdvsComplaintFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Checked entry.
     * Visiosoft LTD.
     * support@visiosoft.com.tr
     * Vedat Akd.
     */
    public function checked(AdvsComplaintModel $model, $id)
    {
        $model->checked($id);
        return back()->withSuccess([trans('visiosoft.module.complaints::message.success')]);
    }
}
