<?php namespace Visiosoft\ComplaintsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ComplaintsModule\ComplainType\Contract\ComplainTypeRepositoryInterface;
use Visiosoft\ComplaintsModule\ComplainType\ComplainTypeRepository;
use Anomaly\Streams\Platform\Model\Complaints\ComplaintsComplainTypesEntryModel;
use Visiosoft\ComplaintsModule\ComplainType\ComplainTypeModel;
use Visiosoft\ComplaintsModule\AdvsComplaint\Contract\AdvsComplaintRepositoryInterface;
use Visiosoft\ComplaintsModule\AdvsComplaint\AdvsComplaintRepository;
use Anomaly\Streams\Platform\Model\Complaints\ComplaintsAdvsComplaintsEntryModel;
use Visiosoft\ComplaintsModule\AdvsComplaint\AdvsComplaintModel;
use Illuminate\Routing\Router;

class ComplaintsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        ComplaintsModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/complaints/complain_types' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\ComplainTypesController@index',
        'admin/complaints/complain_types/create' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\ComplainTypesController@create',
        'admin/complaints/complain_types/edit/{id}' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\ComplainTypesController@edit',
        'admin/complaints' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\AdvsComplaintsController@index',
        'admin/complaints/create' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\AdvsComplaintsController@create',
        'admin/complaints/edit/{id}' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\AdvsComplaintsController@edit',
        'complaints/save_complaint' => [
            'as' => 'save_complaint',
            'uses' => 'Visiosoft\ComplaintsModule\Http\Controller\complaintsController@store',
        ],
        'admin/complaints/checked/{id}' => [
            'as' => 'complaint_checked',
            'uses' => 'Visiosoft\ComplaintsModule\Http\Controller\Admin\AdvsComplaintsController@checked',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\ComplaintsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\ComplaintsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\ComplaintsModule\Event\ExampleEvent::class => [
        //    Visiosoft\ComplaintsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\ComplaintsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        ComplaintsComplainTypesEntryModel::class => ComplainTypeModel::class,
        ComplaintsAdvsComplaintsEntryModel::class => AdvsComplaintModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ComplainTypeRepositoryInterface::class => ComplainTypeRepository::class,
        AdvsComplaintRepositoryInterface::class => AdvsComplaintRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
