<?php namespace Visiosoft\ComplaintsModule\AdvsComplaint\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class AdvsComplaintTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'description',
            'parent_adv'
        ],
        'parent_adv',
        'type',
        'is_checked'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'parent_adv',
        'type',
        'description',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit',
        'Adv' => [
            'href' => '/advs/adv/{entry.parent_adv_id}'
        ],
        'User' => [
            'href' => '/admin/users/edit/{entry.created_by_id}'
        ]
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
