<?php namespace Visiosoft\ComplaintsModule\UserComplaint\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class UserComplaintTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'description',
        ],
        'reported_person',
        'type',
        'is_checked'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'description',
        'reporting_person',
        'reported_person',
        'type',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit',
        'user_deactive' => [
            'icon' => 'fa fa-exclamation-triangle',
            'type' => 'danger',
            'href' => '/admin/user_deactivate/{entry.reported_person.id}',
        ]
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
