<?php namespace Visiosoft\ComplaintsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\UserRepository;
use Visiosoft\ComplaintsModule\UserComplaint\Form\UserComplaintFormBuilder;
use Visiosoft\ComplaintsModule\UserComplaint\Table\UserComplaintTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\ComplaintsModule\UserComplaint\UserComplaintModel;

class UserComplaintsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param UserComplaintTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(UserComplaintTableBuilder $table)
    {

        $table->setColumns(
            [
                'description',
                'type',
                'reporting_person' => [
                    'value' => function (EntryInterface $entry) {
                        $name = '-';
                        if (!is_null($entry->reporting_person)) {
                            $name = $entry->reporting_person->first_name . ' ' . $entry->reporting_person->last_name;
                        }
                        return "<a  href='/admin/users/edit/{entry.reporting_person.id}' >" . $name . "</a>";
                    }],
                'reported_person' => [
                    'value' => function (EntryInterface $entry) {
                        $name = '-';
                        if (!is_null($entry->reporting_person)) {
                            $name = $entry->reporting_person->first_name . ' ' . $entry->reporting_person->last_name;
                        }
                        return "<a class='text-danger' href='/admin/users/edit/{entry.reported_person.id}'>". $name ."</a>";
                    }]
            ]
        );


        $status = [
            'value' => function (EntryModel $entry) {
                if ($entry->is_checked) {
                    return "<i class='fa fa-check'></i>";
                } else {
                    return "<a href='" . route('complaint_user_checked', [$entry->id]) . "' 
                                class='btn btn-success btn-xs'>" . trans('visiosoft.module.complaints::field.checked.name') . "</a>";
                }
            },
            'field' => 'status',
        ];
        $table->addColumn($status);
        return $table->render();
    }

    public function checked(UserComplaintModel $model, $id)
    {
        $model->checked($id);
        return back()->withSuccess([trans('visiosoft.module.complaints::message.success')]);
    }

    /**
     * Create a new entry.
     *
     * @param UserComplaintFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(UserComplaintFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param UserComplaintFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(UserComplaintFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function UserDeactivate(UserRepository $userRepo, $id)
    {
        $user = $userRepo->find($id);
        $user->setAttribute('enabled', 0);
        $user->setAttribute('activated', 0);
        $user->save();

        $this->messages->success(trans('visiosoft.module.complaints::message.user_deactivate'));
        return $this->redirect->back();
    }
}
