<?php namespace Visiosoft\ComplaintsModule;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Complaints\ComplaintsAdvsComplaintsEntryModel;
use Illuminate\Support\Facades\DB;
use Visiosoft\ComplaintsModule\ComplainType\ComplainTypeModel;


class ComplaintsModuleSeeder extends Seeder
{
    /**
     * Run the seeder.
     */
    public function run()
    {
        DB::table('complaints_complain_types')->truncate();
        DB::table('complaints_complain_types_translations')->truncate();

        $complainTypes = [
            [
                'id' => 1,
                'en' => [
                    'name' => 'The product featured in this ad, is sold or rented.',
                ],
                'tr' => [
                    'name'  => 'İlanda belirtilen ürün/hizmet satılmış ya da kiralanmış',
                ],
                'stream_name' => 'advs',
            ],
            [
                'id' => 2,
                'en' => [
                    'name' => 'Ad categories are faulty.',
                ],
                'tr' => [
                    'name'  => 'İlan kategorisi hatalı',
                ],
                'stream_name' => 'advs',
            ],
            [
                'id' => 3,
                'en' => [
                    'name' => 'Ad information wrong.',
                ],
                'tr' => [
                    'name'  => 'İlan bilgileri hatalı veya yanlış',
                ],
                'stream_name' => 'advs',
            ],
            [
                'id' => 4,
                'en' => [
                    'name' => 'Duplicate Ad.',
                ],
                'tr' => [
                    'name'  => 'İlan birden fazla kere yayımlanmış',
                ],
                'stream_name' => 'advs',
            ],
            [
                'id' => 5,
                'en' => [
                    'name' => 'Inappropriate name or surname.',
                ],
                'tr' => [
                    'name'  => 'Uygun olmayan isim veya soyisim',
                ],
                'stream_name' => 'user',
            ],
            [
                'id' => 6,
                'en' => [
                    'name' => 'Spam messages are sending.',
                ],
                'tr' => [
                    'name'  => 'Spam mesajlar gönderiyor',
                ],
                'stream_name' => 'user',
            ],
        ];

        foreach ($complainTypes as $complainTypeData) {
            ComplainTypeModel::create($complainTypeData);
        }

    }
}