<?php namespace Visiosoft\ComparisonsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;

class ComparisonController extends PublicController
{

    public function listComparison(Request $request, AdvRepositoryInterface $advRepository)
    {
        $advs = [];
        $features = [];

        if ($request->comparisonsIds) {
            $compareadvs = $advRepository->findByIds($request->comparisonsIds);

            $isActive = new AdvModel();


            foreach ($compareadvs as $adv) {
                if ($isActive->is_enabled('customfields')) {
                    $customFieldRepository = app(CustomFieldRepositoryInterface::class);

                    $cf_array = json_decode($adv['cf_json'], true);
                    if (is_array($cf_array)) {
                        foreach ($cf_array as $cf_id => $cf_value) {
                            $customField = $customFieldRepository->find(substr($cf_id, 2));
                            if ($customField && $customField->cfvalues()->count() > 0 && is_array($cf_value)) {
                                $name = "";
                                foreach ($cf_value as $key => $vv) {
                                    $name .= $customField->cfvalues()->find($vv)->custom_field_value . ((count($cf_value) - 1) !=  $key ? ', ' : '');
                                }
                                $features[$customField->name][] = $name;
                            } elseif ($customField) {
                                $features[$customField->name][] = $customField->cfvalues()->find($cf_value)->custom_field_value ?? $cf_value;
                            }
                        }
                    }
                    $advs[] = [$adv, $features];
                } else {
                    $advs[] = [$adv, []];
                }
            }

            $advModel = new AdvModel();

            foreach ($advs as $index => $adv) {
                $advs[$index][0]->detail_url = $advModel->getAdvDetailLinkByModel($adv[0], 'list');
                $advs[$index][0] = $advModel->AddAdsDefaultCoverImage($adv[0]);
            }

        }

        return $this->view->make('visiosoft.module.comparisons::comparelist', compact('advs', 'features'));
    }
}
