$(function () {
    $(".comparison").on('click', function () {
        var idsi = $(this).data('adv');

        if ($(this).hasClass('active')) {
            removeComparison(idsi)

            $(this).removeClass('active')
        } else {
            var title = $(this).data('title');
            var dataimg = $(this).data('img');
            var price = $(this).data('price');
            // localStorage.removeItem('comparisons');
            var jsontext = JSON.parse(localStorage.getItem('comparisons'));
            if (!jsontext || jsontext.length < 4) {
                if (jsontext) {
                    var status = true;
                    $.each(jsontext, function (i, item) {
                        if (idsi == item[0]) {
                            status = false;
                        }
                    });
                    if (status) {
                        jsontext.push([idsi, title, dataimg, price]);
                    }
                } else {
                    jsontext = [];
                    jsontext.push([idsi, title, dataimg, price]);
                }
                localStorage.setItem('comparisons', JSON.stringify(jsontext));
                openComprasionSidebar();

                $(this).addClass('active')
            }
        }
    });

    $("#compare-sidebar").on('click', function () {
        openComprasionSidebar();
    });

    $('#compare-box').on('click', '.comparisonremove', function () {
        removeComparison($(this).data('removeid'))
    });

    $('body').on('click', '#comppanelhide', function () {
        $("#compare-sidebar").removeClass('hide');
        $("#compare-box").addClass('hide');
        $("#compare-elements li").remove();
        $("#scrollUp").css('bottom', '60px');
    });

    $(".remove-ad").on('click', function () {
        adId = this.id;
        $(`.${adId}`).hide()
    });

    // Mark comparison ads on page load
    var jsontext = JSON.parse(localStorage.getItem('comparisons'));
    if (jsontext && typeof jsontext === 'object' && jsontext.length) {
        for (let i = 0; i < jsontext.length; i++) {
            $(`[data-adv=${jsontext[i][0]}]`).addClass('active')
        }
    }
});

function removeComparison(id) {
    newjsontext = [];
    $(`[data-removeid=${id}]`).parent().remove()
    var jsontext = JSON.parse(localStorage.getItem('comparisons'));
    $.each(jsontext, function (i, item) {
        if (item[0] != id) {
            newjsontext.push([item[0], item[1], item[2], item[3]]);
        }
    })
    localStorage.setItem('comparisons', JSON.stringify(newjsontext));
    if (newjsontext.length > 0) {
        $(".comparebtn").attr("disabled", false);
    } else {
        $(".comparebtn").attr("disabled", true);
    }
}

function openComprasionSidebar() {
    $("#scrollUp").css('bottom', '250px');
    $("#compare-box").removeClass('hide');
    var jsontext = JSON.parse(localStorage.getItem('comparisons'));
    $("#compare-elements div").remove();
    if (jsontext && jsontext.length > 0) {
        $.each(jsontext, function (i, item) {
            $("#compare-elements").append(`
                <div class="product mt-2" id="compare-elements">
                    <input type="hidden" name="comparisonsIds[]" value="${item[0]}">
                    <div class="d-flex align-items-center">
                        <div class="p-img rounded"><img src="${item[2]}" alt=""></div>
                        <div class="p-text ml-3">
                            <span class="product-exp text-secondary">${item[1]}</span>
                            <br>
                            <span class="product-price">${item[3]}</span>
                        </div>
                    </div>
                <div class="comparisonremove ml-2" data-removeid="${item[0]}"><i class="fa fa-trash"></i></div></div>
            `);
        });
        $(".comparebtn").attr("disabled", false);
    } else {
        $(".comparebtn").attr("disabled", true);
    }
}
