<?php namespace Visiosoft\ComparisonsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;

class ComparisonController extends PublicController {

    public function listComparison(Request $request, AdvRepositoryInterface $advRepository)
    {
        $advs = [];
        if($request->comparisonsIds){
            $compareadvs = $advRepository->findByIds($request->comparisonsIds);

            $isActive = new AdvModel();
            
    
            foreach($compareadvs as $adv){
                if ($isActive->is_enabled('customfields')) {
                    $cf_array = json_decode($adv['cf_json'], true);
                    $features = array();
                    $findcustomfields = $adv->customfields;
                    foreach ($findcustomfields as $fcf) {
                        if ($fcf->customfield->cfvalues()->count() > 0 && is_array($cf_array['cf' . $fcf->customfield->id])) {
                            foreach ($cf_array['cf' . $fcf->customfield->id] as $vv) {
                                // if($vv == $cf_array['cf'.$fcf->customfield->id]){
                                $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->customfield->cfvalues()->find($vv)->custom_field_value];
                                // }
                            }
                        } else if ($fcf->customfield->cfvalues()->count() > 0) {
                            $x = $fcf->customfield->cfvalues()->find($fcf->custom_field_value);
                            $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->customfield->cfvalues()->find($fcf->custom_field_value)->custom_field_value];
                        } else {
                            $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->custom_field_value];
                        }
                    }
                    $advs[] = [$adv, $features];
                }else{
                    $advs[] = [$adv, []];
                }
            }
            
            $advModel = new AdvModel();
    
            foreach ($advs as $index => $adv)
            {
                $advs[$index][0]->detail_url = $advModel->getAdvDetailLinkByModel($adv[0],'list');
                $advs[$index][0] = $advModel->AddAdsDefaultCoverImage($adv[0]);
            }
        
        }

        return $this->view->make('visiosoft.module.comparisons::comparelist', compact('advs'));
    }
}
