<?php namespace Visiosoft\CommentsModule\Comment;

use Visiosoft\CommentsModule\Comment\Contract\CommentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CommentRepository extends EntryRepository implements CommentRepositoryInterface
{
    protected $model;

    public function __construct(CommentModel $model)
    {
        $this->model = $model;
    }

    public function getRating($entry_type, $entry_id)
    {
        $rating = $this->newQuery()
            ->where('entry_type', $entry_type)
            ->where('entry_id', $entry_id)
	        ->where('status', 1)
            ->get();

        if (count($rating))
        {
            $total = $rating->sum('rating');
            $count = $rating->count();
            $rating = $total / $count;
        } else {
            $rating = 0;
        }
        return [
        	'rating' => $rating,
	        'count' => $count ?? 0,
        ];
    }
}
