<?php namespace Visiosoft\CommentsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CommentsModule\Comment\Command\getComments;

class CommentsModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getComments',
                function ($entry_type, $id) {

                    if (!$comments = $this->dispatch(new getComments($entry_type, $id))) {
                        return null;
                    }
                    return $comments;
                }
            )
        ];
    }
}
