<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\AdvsModule\Adv\AdvModel;

class VisiosoftModuleCommentsCreateCommentsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class,
                "default_value" => 0,
            ]
        ],
        'username' => 'anomaly.field_type.text',
        'title' => 'anomaly.field_type.text',
        'rating' => 'anomaly.field_type.integer',
        'detail' => [
            "type"   => "anomaly.field_type.textarea",
            "config" => [
                "rows"  => 6
            ]
        ], 
        'status' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => 0,
            ]
        ]
    ];

}
