<?php namespace Visiosoft\CommentsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CommentsModule\Comment\Command\getComments;
use Visiosoft\CommentsModule\Comment\Contract\CommentRepositoryInterface;

class CommentsModulePlugin extends Plugin
{
    private $repository;

    public function __construct(CommentRepositoryInterface $commentRepository)
    {
        $this->repository = $commentRepository;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getComments',
                function ($entry_type, $id) {

                    if (!$comments = $this->dispatch(new getComments($entry_type, $id))) {
                        return null;
                    }
                    return $comments;
                }
            ),new \Twig_SimpleFunction(
                'getRating',
                function ($entry_type, $entry_id) {
                    if (!$rating = $this->repository->getRating($entry_type, $entry_id)) {
                        return null;
                    }
                    return $rating;
                }
            )
        ];
    }
}
