<?php namespace Visiosoft\CommentsModule\Comment;

use Visiosoft\CommentsModule\Comment\Contract\CommentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CommentRepository extends EntryRepository implements CommentRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CommentModel
     */
    protected $model;

    /**
     * Create a new CommentRepository instance.
     *
     * @param CommentModel $model
     */
    public function __construct(CommentModel $model)
    {
        $this->model = $model;
    }

    public function getRating($entry_type, $entry_id)
    {
        $rating = $this->newQuery()
            ->where('entry_type', $entry_type)
            ->where('entry_id', $entry_id)
            ->get();

        if (count($rating))
        {
            $total = $rating->sum('rating');
            $count = $rating->count();
            $rating = $total / $count;
        }
        return $rating;
    }
}
