<?php namespace Visiosoft\CoinsModule\Listener;

use Illuminate\Support\Facades\DB;
use Visiosoft\CartsModule\Saleitem\Event\SaleItemSaved;

class TotalCoinForCart
{
	public function handle(SaleItemSaved $event)
	{
		$item = $event->getSaleItem();

		if ($price = calculatePrice($item->price)) {
			DB::table('carts_saleitems')->where('id', $item->id)->update([
				'coin_price' => $price * $item->quantity
			]);
		}
		$total = 0;
		foreach ($item->cart->items as $val){
			$total += $val->coin_price;
		}

		DB::table('carts_carts')->where('id', $item->cart_id)->update([
			'coin_total_price' => $total
		]);
	}
}
