<?php

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class VisiosoftModuleCoinsAddCoinsTotalForOrders extends Migration
{
	private $fieldRepository;
	private $streamRepository;
	private $assignmentRepository;

	protected $columns = [
		[
			'stream' => 'order',
			'field' => [
				'slug' => 'coin_total_price',
				'namespace' => 'orders',
				'type' => 'visiosoft.field_type.decimal',
			],
		], [
			'stream' => 'order',
			'field' => [
				'slug' => 'coin_wallet',
				'namespace' => 'orders',
				'type' => 'anomaly.field_type.text',
			],
		], [
			'stream' => 'orderdetail',
			'field' => [
				'slug' => 'coin_price',
				'namespace' => 'orders',
				'type' => 'visiosoft.field_type.decimal',
			]
		]
	];


	public function __construct(
		FieldRepositoryInterface $fieldRepository,
		StreamRepositoryInterface $streamRepository,
		AssignmentRepositoryInterface $assignmentRepository
	)
	{
		$this->fieldRepository = $fieldRepository;
		$this->streamRepository = $streamRepository;
		$this->assignmentRepository = $assignmentRepository;
	}

	public function up()
	{
		foreach ($this->columns as $column) {
			if ($stream = $this->streamRepository->findBySlugAndNamespace($column['stream'], 'orders')) {
				if (!$field = $this->fieldRepository->findBySlugAndNamespace($column['field']['slug'], $column['field']['namespace'])) {
					$field = $this->fieldRepository->create([
						'slug' => $column['field']['slug'],
						'namespace' => $column['field']['namespace'],
						'type' => $column['field']['type'],
						'locked' => 0,
					]);
				}

				$this->assignmentRepository->create([
					'stream' => $stream,
					'field' => $field,
				]);
			}
		}
	}
}
