<?php namespace Visiosoft\CoinsModule\Listener;

use Illuminate\Support\Facades\DB;
use Visiosoft\OrdersModule\Orderdetail\Event\CreatedOrderDetail;

class CoinForOrderDetail
{
	public function handle(CreatedOrderDetail $event)
	{
		$item = $event->getOrderItem();

		if ($item->order->pay_type === 'coin') {
			DB::table('orders_orderdetail')->where('id', $item->id)->update([
				'coin_price' => $item->price * getCoinRates()
			]);
		}
	}
}
