<?php

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class VisiosoftModuleCoinsAddCoinItemsForCart extends Migration
{
	private $fieldRepository;
	private $streamRepository;
	private $assignmentRepository;

	public function __construct(
		FieldRepositoryInterface $fieldRepository,
		StreamRepositoryInterface $streamRepository,
		AssignmentRepositoryInterface $assignmentRepository
	)
	{
		$this->fieldRepository = $fieldRepository;
		$this->streamRepository = $streamRepository;
		$this->assignmentRepository = $assignmentRepository;
	}

	protected $columns = [
		[
			'stream' => 'carts',
			'field' => [
				'slug' => 'coin_total_price',
				'namespace' => 'carts',
				'type' => 'visiosoft.field_type.decimal',
			],
		], [
			'stream' => 'saleitems',
			'field' => [
				'slug' => 'coin_price',
				'namespace' => 'carts',
				'type' => 'anomaly.field_type.text',
			],
		]
	];

	public function up()
	{
		foreach ($this->columns as $column) {
			if ($stream = $this->streamRepository->findBySlugAndNamespace($column['stream'], 'carts')) {
				if (!$field = $this->fieldRepository->findBySlugAndNamespace($column['field']['slug'], $column['field']['namespace'])) {
					$field = $this->fieldRepository->create([
						'slug' => $column['field']['slug'],
						'namespace' => $column['field']['namespace'],
						'type' => $column['field']['type'],
						'locked' => 0,
					]);
				}
				$this->assignmentRepository->create([
					'stream' => $stream,
					'field' => $field,
				]);
			}
		}
	}
}
