<?php namespace Visiosoft\CloudinaryModule\Video\Listeners;

use Visiosoft\CloudinaryModule\Video\Contract\VideoRepositoryInterface;

class EditedAd
{
    protected $repository;

    public function __construct(VideoRepositoryInterface $repository)
    {
        $this->repository = $repository;
    }

    public function handle(\Visiosoft\AdvsModule\Adv\Event\EditedAd $event)
    {
        $ad = $event->getAdDetail();
        if (request()->has('video_url')) {
            $url = request('video_url');
            if ($this->check_new_video($url, $ad->cover_photo)) {
                $this->repository->saveVideo($ad, $url);
            }
        }
    }

    public function check_new_video($url, $cover_photo)
    {
        if ($cover_photo) {
            $cover_photo_file_name = $this->getFileName($cover_photo);
            $url_file_name = $this->getFileName($url);

            if ($url_file_name == $cover_photo_file_name) {
                return false;
            }
            return true;
        }
        return true;
    }

    public function getFileName($url)
    {
        $explode_url = explode('/', $url);
        $explode_file_name = array_first(explode('.', end($explode_url)));

        return $explode_file_name;
    }
}