<?php namespace Visiosoft\CloudinaryModule\Video;

use Visiosoft\CloudinaryModule\Video\Contract\VideoInterface;
use Anomaly\Streams\Platform\Model\Cloudinary\CloudinaryVideoEntryModel;

class VideoModel extends CloudinaryVideoEntryModel implements VideoInterface
{
    public function getVideo($id = null)
    {
        if($id != null)
        {
            return VideoModel::query()->where('adv',$id);
        }
        return VideoModel::query();
    }

    public function updateRequest($request)
    {

        if(count( $this->getVideo($request->update_id)->get()) > 0)
        {
            $this->getVideo($request->update_id)->get()->update(['adv' => $request->update_id, 'url' => $request->url, 'cloudName' => $request->cloudName,
                'uploadKey' => $request->uploadKey, 'filename' => $request->filename]);
        } else {
            $this->createRequest($request);
        }
    }

    public function createRequest($request,$id = null)
    {
        if($id != null)
        {
            $request->update_id = $id;
        }
        if($request->url != "")
        {
            $this->getVideo()->create(['adv' => $request->update_id, 'url' => $request->url, 'cloudName' => $request->cloudName,
                'uploadKey' => $request->uploadKey, 'filename' => $request->filename]);
        }
    }
}
