<?php namespace Visiosoft\CloudinaryModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\CloudinaryModule\Video\Contract\VideoRepositoryInterface;

class VideoController extends PublicController
{
    private $videoRepository;
    public function __construct(
        VideoRepositoryInterface $repository
    )
    {
        $this->videoRepository = $repository;

        parent::__construct();
    }
    public function getVideoUrl($ad_id)
    {
        return ($video = $this->videoRepository->findBy('entry_id', $ad_id)) ? $video->url : null;
    }

    public function getGifVideoUrl($ad_id)
    {
        $url = $this->videoRepository->findBy('entry_id', $ad_id);
        if (!$url) {
            return null;
        }
        $gif_parameters = explode('/', $url);
        $file_names = explode('.', end($gif_parameters), -1);
        $file_name = "";
        if (count($file_names) > 1) {
            for ($i = 0; $i <= count($file_names); $i++) {

                if ($i == count($file_names)) {
                    $file_name .= ".gif";
                } else {
                    if ($i != 0) {
                        $file_name .= ".".$file_names[$i] ;
                    } else {
                        $file_name .= $file_names[$i] ;
                    }
                }

            }
        } else {
            $file_name = array_first($file_names).".gif";
        }

        return "https://res.cloudinary.com/$gif_parameters[3]/video/upload/w_175,h_120,c_pad,b_blurred:400:15/e_loop/dl_200,vs_40/$gif_parameters[6]/$file_name";

    }
}
