var cloudinary_options = cloudinary.createUploadWidget({
    cloudName: cloudinary_settings.cloudName,
    multiple: false,
    resource_type: 'video',
    client_allowed_formats: ["mp4"],
    show_powered_by: false,
    theme: 'white',
    sources: ['local', 'camera'],
    styles: {
        palette: {
            window: "#5cb85c",
            windowBorder: "#5cb85c",
            tabIcon: "#ffffff",
            menuIcons: "#5cb85c",
            textDark: "#ffffff",
            textLight: "#FFFFFF",
            link: "#5cb85c",
            action: "#FF620C",
            inactiveTabIcon: "#0E2F5A",
            error: "#F44235",
            inProgress: "#5cb85c",
            complete: "#20B832",
            sourceBg: "#ffffff"
        }
    },
    uploadPreset: cloudinary_settings.uploadPreset
}, (error, result) => {
    if (result && result.info && result.info.secure_url) {
        $('input[name="video_url"]').val(result.info.secure_url);
        previewVideo(result.info.secure_url);
        cloudinary_options.close();
    }
});

$('#upload-video').on('click',function () {
    cloudinary_options.open();
});

function previewVideo(url) {
    $('.publish-cloudinary').removeClass('d-none').find('.publish-video').html("<video style='width: 100%;' src='"+url+"' controls muted></video>");
}