<?php namespace Visiosoft\CloudinaryModule\Video;

use Visiosoft\CloudinaryModule\Video\Contract\VideoInterface;
use Anomaly\Streams\Platform\Model\Cloudinary\CloudinaryVideoEntryModel;

class VideoModel extends CloudinaryVideoEntryModel implements VideoInterface
{
    public function getAnimationImageURL()
    {
        $url = $this->url;
        $gif_parameters = explode('/', $url);
        $file_name = array_first(explode('.', end($gif_parameters)));
        return "https://res.cloudinary.com/$gif_parameters[3]/video/upload/w_150,h_150,c_pad,b_white/$gif_parameters[6]/$file_name.gif";
    }
}
