<?php namespace Visiosoft\CloudinaryModule\Video\Listeners;

use Visiosoft\CloudinaryModule\Video\Contract\VideoRepositoryInterface;

class CreatedAd
{
    protected $repository;

    public function __construct(VideoRepositoryInterface $repository)
    {
        $this->repository = $repository;
    }

    public function handle(\Visiosoft\AdvsModule\Adv\Event\CreatedAd $event)
    {
        $ad = $event->getAdDetail();
        if (request()->has('video_url')) {
            $url = request('video_url');
            $this->repository->saveVideo($ad, $url);
        }
    }
}