<?php namespace Visiosoft\CloudinaryModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\CloudinaryModule\Video\Contract\VideoRepositoryInterface;

class VideoController extends PublicController
{
    private $videoRepository;
    public function __construct(
        VideoRepositoryInterface $repository
    )
    {
        $this->videoRepository = $repository;

        parent::__construct();
    }
    public function getVideoUrl($ad_id)
    {
        return ($video = $this->videoRepository->findBy('entry_id', $ad_id)) ? $video->url : null;
    }

    public function getGifVideoUrl($ad_id)
    {
        $url = $this->videoRepository->findBy('entry_id', $ad_id);
        if (!$url) {
            return null;
        }
        $gif_parameters = explode('/', $url);
        $file_name = explode('.', end($gif_parameters), -1);
        if (count($file_name) > 1) {
            $file_name = $file_name[0].'.'.$file_name[1];
        } else {
            $file_name = array_first($file_name);
        }

        return "https://res.cloudinary.com/$gif_parameters[3]/video/upload/w_175,h_120,c_pad,b_blurred:400:15/e_loop/dl_200,vs_40/$gif_parameters[6]/$file_name.gif";

    }
}
