<?php namespace Visiosoft\ClientTicketsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;
use Visiosoft\ClientTicketsModule\Service\TicketApiService;
use Visiosoft\ClientTicketsModule\Ticket\Form\AnswerFormBuilder;
use Visiosoft\ClientTicketsModule\Ticket\Form\LoginFormBuilder;
use Visiosoft\ClientTicketsModule\Ticket\Form\NewTicketFormBuilder;

class ClientTicketsModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        '/admin/client_tickets' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@index',
        '/admin/client_tickets/close/{ticketId}' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@close',
        '/admin/client_tickets/new' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@createTicketForm',
        '/admin/client_tickets/thread/{ticketId}' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@thread'
    ];

    protected $bindings = [
        TicketApiServiceInterface::class => TicketApiService::class,
        'ticket_login_form' => LoginFormBuilder::class,
        'new_ticket_form' => NewTicketFormBuilder::class,
        'answer_ticket_form' => AnswerFormBuilder::class

    ];
}
