<?php namespace Visiosoft\ClientTIcketsModule\Ticket\Form;


use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\ClientTicketsModule\Http\Request\CreateTicketRequest;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;

class NewTicketFormHandler
{
    public function handle(NewTicketFormBuilder $builder, CreateTicketRequest $request, MessageBag $messages)
    {
        $inputs = $request->all();
        $api = app(TicketApiServiceInterface::class);
        $ticket = $api->create($inputs['subject'], $inputs['message'], $inputs['department_id'], $inputs['priority_id'], $inputs['name'], $inputs['email']);
        if (!$ticket['success']) {
            $messages->error($ticket['message']);
        }
        if ($ticket['success']) {
            $messages->success($ticket['message']);
        }
        $builder->setFormResponse(redirect('/admin/client_tickets'));
        return redirect();
    }
}
