<?php namespace Visiosoft\ClientTicketsModule\Service\Contract;

interface TicketApiServiceInterface
{
    public function auth(string $username, string $password);

    public function table($inputs);

    public function create(string $subject, string $message, int $departmentId, int $priorityId, string $name, string $email, $file = null);

    public function answer(int $ticketId, string $message, $file = null);

    public function close(int $ticketId);

    public function references();

    public function thread($ticketId);

    public function retrieveBaseUrl();

    public function retrieveAuthUrl();

    public function retrieveTableUrl();

    public function retrieveCreateUrl();

    public function retrieveAnswerUrl($ticketId);

    public function retrieveCloseUrl($ticketId);

    public function retrieveThreadUrl($ticketId);

    public function retrieveReferencesUrl();

    public function resetAuth();

}