<?php namespace Visiosoft\ClientTicketsModule\Service\Contract;

interface TicketApiServiceInterface
{
    public function auth($username, $password);

    public function getTokenForSite();

    public function table($inputs);

    public function create(string $subject, string $message, int $departmentId, int $priorityId, $file = null);

    public function answer(int $ticketId, string $message, $file = null);

    public function close(int $ticketId);

    public function references();

    public function thread($ticketId);

    public function retrieveBaseUrl();

    public function retrieveAuthUrl();

    public function retrieveTableUrl();

    public function retrieveCreateUrl();

    public function retrieveAnswerUrl($ticketId);

    public function retrieveCloseUrl($ticketId);

    public function retrieveThreadUrl($ticketId);

    public function retrieveReferencesUrl();

    public function resetAuth();

    public function retrieveSiteTokenUrl();

}