<?php namespace Visiosoft\ClientTIcketsModule\Ticket\Form;


use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Http\Request;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;
use Visiosoft\TicketsModule\Http\Request\AnswerRequest;

class AnswerFormHandler
{
    public function handle(AnswerFormBuilder $builder, AnswerRequest $request, MessageBag $messages)
    {
        $inputs = $request->all();
        $api = app(TicketApiServiceInterface::class);
        $answer = $api->answer($inputs['ticket_id'], $inputs['content']);
        if (!$answer['success']) {
            $messages->error($answer['message']);
        }
        $messages->success($answer['message']);

        return redirect()->back();
    }
}
