<?php

namespace Visiosoft\ClientTicketsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Http\Request;
use Visiosoft\ClientTicketsModule\Http\Request\AnswerTicketRequest;
use Visiosoft\ClientTicketsModule\Http\Request\CreateTicketRequest;
use Visiosoft\ClientTicketsModule\Http\Request\LoginTicketRequest;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;


class TicketController extends AdminController
{
    public $api;

    public function __construct(TicketApiServiceInterface $ticketApiService)
    {
        $this->api = $ticketApiService;
        parent::__construct();
    }


    public function index(Request $request)
    {
        $inputs = $request->all();
        $results = $this->api->table($inputs);
        if (!empty($results['error'])) {
            $data = [];
        } else {
            $data = $results['data'];
        }
        return $this->view->make('module::tickets', ['results' => $data]);
    }

    public function createTicketForm()
    {
        return $this->view->make('module::new');
    }

    public function thread($ticketId)
    {
        $thread = $this->api->thread($ticketId);
        return $this->view->make('module::thread', ['ticket' => $thread['data']]);
    }

    public function close($ticketId, MessageBag $messages)
    {
        $closed = $this->api->close($ticketId);
        if (!$closed['success']) {
            $messages->error($closed['message']);
        }
        $messages->success($closed['message']);
        return redirect()->back();
    }
}