<?php namespace Visiosoft\ClientTIcketsModule\Ticket\Form;


use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\ClientTicketsModule\Http\Request\AnswerTicketRequest;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;

class AnswerFormHandler
{
    public function handle(AnswerFormBuilder $builder, AnswerTicketRequest $request, MessageBag $messages)
    {
        $inputs = $request->all();
        $api = app(TicketApiServiceInterface::class);
        $answer = $api->answer($inputs['ticket_id'], $inputs['content']);
        if (array_key_exists('status',$answer)) {
            if (!$answer['status']) {
                $messages->error($answer['message']);
                return redirect();
            }
        }
        if (!$answer['success']) {
            $messages->error($answer['message']);
        } else {
            $messages->success($answer['message']);
        }
        return redirect();
    }
}
