<?php namespace Visiosoft\ClientTicketsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Routing\Router;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;
use Visiosoft\ClientTicketsModule\Service\TicketApiService;
use Visiosoft\ClientTicketsModule\Ticket\Form\AnswerFormBuilder;
use Visiosoft\ClientTicketsModule\Ticket\Form\LoginFormBuilder;
use Visiosoft\ClientTicketsModule\Ticket\Form\NewTicketFormBuilder;

class ClientTicketsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        '/admin/client_tickets/auto_login' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@index',
        '/admin/client_tickets' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@index',
        '/admin/client_tickets/close/{ticketId}' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@close',
        '/admin/client_tickets/new' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@createTicketForm',
        '/admin/client_tickets/thread/{ticketId}' => 'Visiosoft\ClientTicketsModule\Http\Controller\Admin\TicketController@thread'
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\ClientTicketsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\ClientTicketsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\ClientTicketsModule\Event\ExampleEvent::class => [
        //    Visiosoft\ClientTicketsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\ClientTicketsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TicketApiServiceInterface::class => TicketApiService::class,
        'ticket_login_form' => LoginFormBuilder::class,
        'new_ticket_form' => NewTicketFormBuilder::class,
        'answer_ticket_form' => AnswerFormBuilder::class

    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
