<?php namespace Visiosoft\ClientTicketsModule\Ticket\Form;

use Illuminate\Support\Facades\Auth;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;

class NewTicketFormFields
{
    public function handle(NewTicketFormBuilder $builder)
    {
        $api = app(TicketApiServiceInterface::class);
        $references = $api->references();
        $builder->setFields(
            [
                'subject' => [
                    'label' => '<strong>' . trans('visiosoft.module.client_tickets::field.subject.name') . '</strong>',
                    'type' => 'anomaly.field_type.text',
                    'required' => true,
                ],
                'department_id' => [
                    'label' => '<strong>' . trans('visiosoft.module.client_tickets::field.department.name') . '</strong>',
                    'type' => 'anomaly.field_type.select',
                    'required' => true,
                    'config' => [
                        'options' => $references['data']['departments']
                    ]
                ],
                'priority_id' => [
                    'label' => '<strong>' . trans('visiosoft.module.client_tickets::field.priority.name') . '</strong>',
                    'type' => 'anomaly.field_type.select',
                    'required' => true,
                    'config' => [
                        'options' => $references['data']['priorities']
                    ]
                ],
                'message' => [
                    'label' => '<strong>' . trans('visiosoft.module.client_tickets::field.message.name') . '</strong>',
                    'type' => 'anomaly.field_type.wysiwyg',
                    'required' => true
                ],]
        );
    }
}
