<?php

namespace Visiosoft\ClientTicketsModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\SettingRepository;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Http\Request;
use Visiosoft\ClientTicketsModule\Service\Contract\TicketApiServiceInterface;
use Visiosoft\ClientTicketsModule\Ticket\Form\AnswerFormBuilder;


class TicketController extends AdminController
{
    public $api;

    public function __construct(TicketApiServiceInterface $ticketApiService)
    {
        $this->api = $ticketApiService;
        parent::__construct();
    }


    public function index(Request $request)
    {
        $inputs = $request->all();
        if (empty(setting_value('visiosoft.module.client_tickets::token')) && !empty(env('AUTO_TOKEN'))) {
            $this->api->getTokenForSite();
        }
        $results = $this->api->table($inputs);
        $data = [];
        if (!empty($results['data'])) {
            $data = $results['data'];
        }
        return $this->view->make('module::tickets', ['results' => $data]);
    }

    public function createTicketForm()
    {
        return $this->view->make('module::new');
    }

    public function thread(AnswerFormBuilder $builder, MessageBag $message, $ticketId)
    {
        $thread = $this->api->thread($ticketId);
        return $this->view->make('module::thread', ['ticket' => $thread['data']]);
    }

    public function close($ticketId, MessageBag $messages)
    {
        $closed = $this->api->close($ticketId);
        if (!$closed['success']) {
            $messages->error($closed['message']);
        }
        $messages->success($closed['message']);
        return redirect()->back();
    }
}